<?php

// scoper-autoload.php @generated by PhpScoper

// Backup the autoloaded Composer files
if (isset($GLOBALS['__composer_autoload_files'])) {
    $existingComposerAutoloadFiles = $GLOBALS['__composer_autoload_files'];
}

$loader = require_once __DIR__.'/autoload.php';
// Ensure InstalledVersions is available
$installedVersionsPath = __DIR__.'/composer/InstalledVersions.php';
if (file_exists($installedVersionsPath)) require_once $installedVersionsPath;

// Restore the backup
if (isset($existingComposerAutoloadFiles)) {
    $GLOBALS['__composer_autoload_files'] = $existingComposerAutoloadFiles;
} else {
    unset($GLOBALS['__composer_autoload_files']);
}

// Class aliases. For more information see:
// https://github.com/humbug/php-scoper/blob/master/docs/further-reading.md#class-aliases
if (!function_exists('humbug_phpscoper_expose_class')) {
    function humbug_phpscoper_expose_class(string $exposed, string $prefixed): void {
        if (!class_exists($exposed, false) && !interface_exists($exposed, false) && !trait_exists($exposed, false)) {
            spl_autoload_call($prefixed);
        }
    }
}
humbug_phpscoper_expose_class('Error', 'Matomo\Dependencies\GoogleAnalyticsImporter\Error');
humbug_phpscoper_expose_class('ArithmeticError', 'Matomo\Dependencies\GoogleAnalyticsImporter\ArithmeticError');
humbug_phpscoper_expose_class('DivisionByZeroError', 'Matomo\Dependencies\GoogleAnalyticsImporter\DivisionByZeroError');
humbug_phpscoper_expose_class('TypeError', 'Matomo\Dependencies\GoogleAnalyticsImporter\TypeError');
humbug_phpscoper_expose_class('ArgumentCountError', 'Matomo\Dependencies\GoogleAnalyticsImporter\ArgumentCountError');
humbug_phpscoper_expose_class('ValueError', 'Matomo\Dependencies\GoogleAnalyticsImporter\ValueError');

// Function aliases. For more information see:
// https://github.com/humbug/php-scoper/blob/master/docs/further-reading.md#function-aliases
if (!function_exists('bcadd')) { function bcadd() { return \Matomo\Dependencies\GoogleAnalyticsImporter\bcadd(...func_get_args()); } }
if (!function_exists('bccomp')) { function bccomp() { return \Matomo\Dependencies\GoogleAnalyticsImporter\bccomp(...func_get_args()); } }
if (!function_exists('bcdiv')) { function bcdiv() { return \Matomo\Dependencies\GoogleAnalyticsImporter\bcdiv(...func_get_args()); } }
if (!function_exists('bcmod')) { function bcmod() { return \Matomo\Dependencies\GoogleAnalyticsImporter\bcmod(...func_get_args()); } }
if (!function_exists('bcmul')) { function bcmul() { return \Matomo\Dependencies\GoogleAnalyticsImporter\bcmul(...func_get_args()); } }
if (!function_exists('bcpow')) { function bcpow() { return \Matomo\Dependencies\GoogleAnalyticsImporter\bcpow(...func_get_args()); } }
if (!function_exists('bcpowmod')) { function bcpowmod() { return \Matomo\Dependencies\GoogleAnalyticsImporter\bcpowmod(...func_get_args()); } }
if (!function_exists('bcscale')) { function bcscale() { return \Matomo\Dependencies\GoogleAnalyticsImporter\bcscale(...func_get_args()); } }
if (!function_exists('bcsqrt')) { function bcsqrt() { return \Matomo\Dependencies\GoogleAnalyticsImporter\bcsqrt(...func_get_args()); } }
if (!function_exists('bcsub')) { function bcsub() { return \Matomo\Dependencies\GoogleAnalyticsImporter\bcsub(...func_get_args()); } }
if (!function_exists('getallheaders')) { function getallheaders() { return \Matomo\Dependencies\GoogleAnalyticsImporter\getallheaders(...func_get_args()); } }

return $loader;
