<?php

/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
namespace Matomo\Dependencies\GoogleAnalyticsImporter\Google\Service\Oauth2;

class Userinfo extends \Matomo\Dependencies\GoogleAnalyticsImporter\Google\Model
{
    protected $internal_gapi_mappings = ["familyName" => "family_name", "givenName" => "given_name", "verifiedEmail" => "verified_email"];
    public $email;
    public $familyName;
    public $gender;
    public $givenName;
    public $hd;
    public $id;
    public $link;
    public $locale;
    public $name;
    public $picture;
    public $verifiedEmail;
    public function setEmail($email)
    {
        $this->email = $email;
    }
    public function getEmail()
    {
        return $this->email;
    }
    public function setFamilyName($familyName)
    {
        $this->familyName = $familyName;
    }
    public function getFamilyName()
    {
        return $this->familyName;
    }
    public function setGender($gender)
    {
        $this->gender = $gender;
    }
    public function getGender()
    {
        return $this->gender;
    }
    public function setGivenName($givenName)
    {
        $this->givenName = $givenName;
    }
    public function getGivenName()
    {
        return $this->givenName;
    }
    public function setHd($hd)
    {
        $this->hd = $hd;
    }
    public function getHd()
    {
        return $this->hd;
    }
    public function setId($id)
    {
        $this->id = $id;
    }
    public function getId()
    {
        return $this->id;
    }
    public function setLink($link)
    {
        $this->link = $link;
    }
    public function getLink()
    {
        return $this->link;
    }
    public function setLocale($locale)
    {
        $this->locale = $locale;
    }
    public function getLocale()
    {
        return $this->locale;
    }
    public function setName($name)
    {
        $this->name = $name;
    }
    public function getName()
    {
        return $this->name;
    }
    public function setPicture($picture)
    {
        $this->picture = $picture;
    }
    public function getPicture()
    {
        return $this->picture;
    }
    public function setVerifiedEmail($verifiedEmail)
    {
        $this->verifiedEmail = $verifiedEmail;
    }
    public function getVerifiedEmail()
    {
        return $this->verifiedEmail;
    }
}
// Adding a class alias for backwards compatibility with the previous class name.
class_alias(Userinfo::class, 'Matomo\\Dependencies\\GoogleAnalyticsImporter\\Google_Service_Oauth2_Userinfo');
